% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arvados.R
\name{Arvados}
\alias{Arvados}
\title{Arvados}
\description{
Arvados

Arvados
}
\details{
This class implements a full REST client to the Arvados API.
}
\examples{
\dontrun{
arv <- Arvados$new("your Arvados token", "example.arvadosapi.com")

collection <- arv$collections.get("uuid")

collectionList <- arv$collections.list(list(list("name", "like", "Test\%")))
collectionList <- listAll(arv$collections.list, list(list("name", "like", "Test\%")))

deletedCollection <- arv$collections.delete("uuid")

updatedCollection <- arv$collections.update(list(name = "New name", description = "New description"),
                                            "uuid")

createdCollection <- arv$collections.create(list(name = "Example",
                                                 description = "This is a test collection"))
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Arvados$new()}}
\item \href{#method-api_client_authorizations_get}{\code{Arvados$api_client_authorizations_get()}}
\item \href{#method-api_client_authorizations_list}{\code{Arvados$api_client_authorizations_list()}}
\item \href{#method-api_client_authorizations_create}{\code{Arvados$api_client_authorizations_create()}}
\item \href{#method-api_client_authorizations_update}{\code{Arvados$api_client_authorizations_update()}}
\item \href{#method-api_client_authorizations_delete}{\code{Arvados$api_client_authorizations_delete()}}
\item \href{#method-api_client_authorizations_create_system_auth}{\code{Arvados$api_client_authorizations_create_system_auth()}}
\item \href{#method-api_client_authorizations_current}{\code{Arvados$api_client_authorizations_current()}}
\item \href{#method-authorized_keys_get}{\code{Arvados$authorized_keys_get()}}
\item \href{#method-authorized_keys_list}{\code{Arvados$authorized_keys_list()}}
\item \href{#method-authorized_keys_create}{\code{Arvados$authorized_keys_create()}}
\item \href{#method-authorized_keys_update}{\code{Arvados$authorized_keys_update()}}
\item \href{#method-authorized_keys_delete}{\code{Arvados$authorized_keys_delete()}}
\item \href{#method-collections_get}{\code{Arvados$collections_get()}}
\item \href{#method-collections_list}{\code{Arvados$collections_list()}}
\item \href{#method-collections_create}{\code{Arvados$collections_create()}}
\item \href{#method-collections_update}{\code{Arvados$collections_update()}}
\item \href{#method-collections_delete}{\code{Arvados$collections_delete()}}
\item \href{#method-collections_provenance}{\code{Arvados$collections_provenance()}}
\item \href{#method-collections_used_by}{\code{Arvados$collections_used_by()}}
\item \href{#method-collections_trash}{\code{Arvados$collections_trash()}}
\item \href{#method-collections_untrash}{\code{Arvados$collections_untrash()}}
\item \href{#method-computed_permissions_list}{\code{Arvados$computed_permissions_list()}}
\item \href{#method-containers_get}{\code{Arvados$containers_get()}}
\item \href{#method-containers_list}{\code{Arvados$containers_list()}}
\item \href{#method-containers_create}{\code{Arvados$containers_create()}}
\item \href{#method-containers_update}{\code{Arvados$containers_update()}}
\item \href{#method-containers_delete}{\code{Arvados$containers_delete()}}
\item \href{#method-containers_auth}{\code{Arvados$containers_auth()}}
\item \href{#method-containers_lock}{\code{Arvados$containers_lock()}}
\item \href{#method-containers_unlock}{\code{Arvados$containers_unlock()}}
\item \href{#method-containers_update_priority}{\code{Arvados$containers_update_priority()}}
\item \href{#method-containers_secret_mounts}{\code{Arvados$containers_secret_mounts()}}
\item \href{#method-containers_current}{\code{Arvados$containers_current()}}
\item \href{#method-container_requests_get}{\code{Arvados$container_requests_get()}}
\item \href{#method-container_requests_list}{\code{Arvados$container_requests_list()}}
\item \href{#method-container_requests_create}{\code{Arvados$container_requests_create()}}
\item \href{#method-container_requests_update}{\code{Arvados$container_requests_update()}}
\item \href{#method-container_requests_delete}{\code{Arvados$container_requests_delete()}}
\item \href{#method-container_requests_container_status}{\code{Arvados$container_requests_container_status()}}
\item \href{#method-groups_get}{\code{Arvados$groups_get()}}
\item \href{#method-groups_list}{\code{Arvados$groups_list()}}
\item \href{#method-groups_create}{\code{Arvados$groups_create()}}
\item \href{#method-groups_update}{\code{Arvados$groups_update()}}
\item \href{#method-groups_delete}{\code{Arvados$groups_delete()}}
\item \href{#method-groups_contents}{\code{Arvados$groups_contents()}}
\item \href{#method-groups_shared}{\code{Arvados$groups_shared()}}
\item \href{#method-groups_trash}{\code{Arvados$groups_trash()}}
\item \href{#method-groups_untrash}{\code{Arvados$groups_untrash()}}
\item \href{#method-keep_services_get}{\code{Arvados$keep_services_get()}}
\item \href{#method-keep_services_list}{\code{Arvados$keep_services_list()}}
\item \href{#method-keep_services_create}{\code{Arvados$keep_services_create()}}
\item \href{#method-keep_services_update}{\code{Arvados$keep_services_update()}}
\item \href{#method-keep_services_delete}{\code{Arvados$keep_services_delete()}}
\item \href{#method-keep_services_accessible}{\code{Arvados$keep_services_accessible()}}
\item \href{#method-links_get}{\code{Arvados$links_get()}}
\item \href{#method-links_list}{\code{Arvados$links_list()}}
\item \href{#method-links_create}{\code{Arvados$links_create()}}
\item \href{#method-links_update}{\code{Arvados$links_update()}}
\item \href{#method-links_delete}{\code{Arvados$links_delete()}}
\item \href{#method-links_get_permissions}{\code{Arvados$links_get_permissions()}}
\item \href{#method-logs_get}{\code{Arvados$logs_get()}}
\item \href{#method-logs_list}{\code{Arvados$logs_list()}}
\item \href{#method-logs_create}{\code{Arvados$logs_create()}}
\item \href{#method-logs_update}{\code{Arvados$logs_update()}}
\item \href{#method-logs_delete}{\code{Arvados$logs_delete()}}
\item \href{#method-users_get}{\code{Arvados$users_get()}}
\item \href{#method-users_list}{\code{Arvados$users_list()}}
\item \href{#method-users_create}{\code{Arvados$users_create()}}
\item \href{#method-users_update}{\code{Arvados$users_update()}}
\item \href{#method-users_delete}{\code{Arvados$users_delete()}}
\item \href{#method-users_current}{\code{Arvados$users_current()}}
\item \href{#method-users_system}{\code{Arvados$users_system()}}
\item \href{#method-users_activate}{\code{Arvados$users_activate()}}
\item \href{#method-users_setup}{\code{Arvados$users_setup()}}
\item \href{#method-users_unsetup}{\code{Arvados$users_unsetup()}}
\item \href{#method-users_merge}{\code{Arvados$users_merge()}}
\item \href{#method-user_agreements_get}{\code{Arvados$user_agreements_get()}}
\item \href{#method-user_agreements_list}{\code{Arvados$user_agreements_list()}}
\item \href{#method-user_agreements_create}{\code{Arvados$user_agreements_create()}}
\item \href{#method-user_agreements_update}{\code{Arvados$user_agreements_update()}}
\item \href{#method-user_agreements_delete}{\code{Arvados$user_agreements_delete()}}
\item \href{#method-user_agreements_signatures}{\code{Arvados$user_agreements_signatures()}}
\item \href{#method-user_agreements_sign}{\code{Arvados$user_agreements_sign()}}
\item \href{#method-virtual_machines_get}{\code{Arvados$virtual_machines_get()}}
\item \href{#method-virtual_machines_list}{\code{Arvados$virtual_machines_list()}}
\item \href{#method-virtual_machines_create}{\code{Arvados$virtual_machines_create()}}
\item \href{#method-virtual_machines_update}{\code{Arvados$virtual_machines_update()}}
\item \href{#method-virtual_machines_delete}{\code{Arvados$virtual_machines_delete()}}
\item \href{#method-virtual_machines_logins}{\code{Arvados$virtual_machines_logins()}}
\item \href{#method-virtual_machines_get_all_logins}{\code{Arvados$virtual_machines_get_all_logins()}}
\item \href{#method-workflows_get}{\code{Arvados$workflows_get()}}
\item \href{#method-workflows_list}{\code{Arvados$workflows_list()}}
\item \href{#method-workflows_create}{\code{Arvados$workflows_create()}}
\item \href{#method-workflows_update}{\code{Arvados$workflows_update()}}
\item \href{#method-workflows_delete}{\code{Arvados$workflows_delete()}}
\item \href{#method-configs_get}{\code{Arvados$configs_get()}}
\item \href{#method-vocabularies_get}{\code{Arvados$vocabularies_get()}}
\item \href{#method-sys_get}{\code{Arvados$sys_get()}}
\item \href{#method-project_get}{\code{Arvados$project_get()}}
\item \href{#method-project_create}{\code{Arvados$project_create()}}
\item \href{#method-project_update}{\code{Arvados$project_update()}}
\item \href{#method-project_list}{\code{Arvados$project_list()}}
\item \href{#method-project_delete}{\code{Arvados$project_delete()}}
\item \href{#method-project_exist}{\code{Arvados$project_exist()}}
\item \href{#method-project_properties_set}{\code{Arvados$project_properties_set()}}
\item \href{#method-project_properties_append}{\code{Arvados$project_properties_append()}}
\item \href{#method-project_properties_get}{\code{Arvados$project_properties_get()}}
\item \href{#method-project_properties_delete}{\code{Arvados$project_properties_delete()}}
\item \href{#method-project_permission_give}{\code{Arvados$project_permission_give()}}
\item \href{#method-project_permission_update}{\code{Arvados$project_permission_update()}}
\item \href{#method-project_permission_delete}{\code{Arvados$project_permission_delete()}}
\item \href{#method-project_permission_check}{\code{Arvados$project_permission_check()}}
\item \href{#method-getHostName}{\code{Arvados$getHostName()}}
\item \href{#method-getToken}{\code{Arvados$getToken()}}
\item \href{#method-setRESTService}{\code{Arvados$setRESTService()}}
\item \href{#method-getRESTService}{\code{Arvados$getRESTService()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new Arvados API client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$new(authToken = NULL, hostName = NULL, numRetries = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{authToken}}{Authentification token. If not specified ARVADOS_API_TOKEN environment variable will be used.}

\item{\code{hostName}}{Host name. If not specified ARVADOS_API_HOST environment variable will be used.}

\item{\code{numRetries}}{Number which specifies how many times to retry failed service requests.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Arvados} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client_authorizations_get"></a>}}
\if{latex}{\out{\hypertarget{method-api_client_authorizations_get}{}}}
\subsection{Method \code{api_client_authorizations_get()}}{
Get a ApiClientAuthorization record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$api_client_authorizations_get(uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the ApiClientAuthorization to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ApiClientAuthorization object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client_authorizations_list"></a>}}
\if{latex}{\out{\hypertarget{method-api_client_authorizations_list}{}}}
\subsection{Method \code{api_client_authorizations_list()}}{
Retrieve a ApiClientAuthorizationList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$api_client_authorizations_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ApiClientAuthorizationList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client_authorizations_create"></a>}}
\if{latex}{\out{\hypertarget{method-api_client_authorizations_create}{}}}
\subsection{Method \code{api_client_authorizations_create()}}{
Create a new ApiClientAuthorization.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$api_client_authorizations_create(
  apiClientAuthorization,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{apiClientAuthorization}}{ApiClientAuthorization object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ApiClientAuthorization object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client_authorizations_update"></a>}}
\if{latex}{\out{\hypertarget{method-api_client_authorizations_update}{}}}
\subsection{Method \code{api_client_authorizations_update()}}{
Update attributes of an existing ApiClientAuthorization.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$api_client_authorizations_update(
  apiClientAuthorization,
  uuid,
  select = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{apiClientAuthorization}}{ApiClientAuthorization object.}

\item{\code{uuid}}{The UUID of the ApiClientAuthorization to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ApiClientAuthorization object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client_authorizations_delete"></a>}}
\if{latex}{\out{\hypertarget{method-api_client_authorizations_delete}{}}}
\subsection{Method \code{api_client_authorizations_delete()}}{
Delete an existing ApiClientAuthorization.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$api_client_authorizations_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the ApiClientAuthorization to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ApiClientAuthorization object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client_authorizations_create_system_auth"></a>}}
\if{latex}{\out{\hypertarget{method-api_client_authorizations_create_system_auth}{}}}
\subsection{Method \code{api_client_authorizations_create_system_auth()}}{
Create a token for the system ("root") user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$api_client_authorizations_create_system_auth(scopes = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scopes}}{An array of strings defining the scope of resources this token will be allowed to access. Refer to the \href{https://doc.arvados.org/api/tokens.html#scopes}{scopes reference} for details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ApiClientAuthorization object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client_authorizations_current"></a>}}
\if{latex}{\out{\hypertarget{method-api_client_authorizations_current}{}}}
\subsection{Method \code{api_client_authorizations_current()}}{
Return all metadata for the token used to authorize this request.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$api_client_authorizations_current()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
ApiClientAuthorization object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-authorized_keys_get"></a>}}
\if{latex}{\out{\hypertarget{method-authorized_keys_get}{}}}
\subsection{Method \code{authorized_keys_get()}}{
Get a AuthorizedKey record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$authorized_keys_get(uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the AuthorizedKey to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
AuthorizedKey object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-authorized_keys_list"></a>}}
\if{latex}{\out{\hypertarget{method-authorized_keys_list}{}}}
\subsection{Method \code{authorized_keys_list()}}{
Retrieve a AuthorizedKeyList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$authorized_keys_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
AuthorizedKeyList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-authorized_keys_create"></a>}}
\if{latex}{\out{\hypertarget{method-authorized_keys_create}{}}}
\subsection{Method \code{authorized_keys_create()}}{
Create a new AuthorizedKey.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$authorized_keys_create(
  authorizedKey,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{authorizedKey}}{AuthorizedKey object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
AuthorizedKey object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-authorized_keys_update"></a>}}
\if{latex}{\out{\hypertarget{method-authorized_keys_update}{}}}
\subsection{Method \code{authorized_keys_update()}}{
Update attributes of an existing AuthorizedKey.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$authorized_keys_update(authorizedKey, uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{authorizedKey}}{AuthorizedKey object.}

\item{\code{uuid}}{The UUID of the AuthorizedKey to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
AuthorizedKey object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-authorized_keys_delete"></a>}}
\if{latex}{\out{\hypertarget{method-authorized_keys_delete}{}}}
\subsection{Method \code{authorized_keys_delete()}}{
Delete an existing AuthorizedKey.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$authorized_keys_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the AuthorizedKey to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
AuthorizedKey object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-collections_get"></a>}}
\if{latex}{\out{\hypertarget{method-collections_get}{}}}
\subsection{Method \code{collections_get()}}{
Get a Collection record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$collections_get(uuid, select = NULL, includeTrash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Collection to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{includeTrash}}{Show collection even if its \code{is_trashed} attribute is true.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Collection object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-collections_list"></a>}}
\if{latex}{\out{\hypertarget{method-collections_list}{}}}
\subsection{Method \code{collections_list()}}{
Retrieve a CollectionList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$collections_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL,
  includeTrash = NULL,
  includeOldVersions = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}

\item{\code{includeTrash}}{Include collections whose \code{is_trashed} attribute is true.}

\item{\code{includeOldVersions}}{Include past collection versions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
CollectionList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-collections_create"></a>}}
\if{latex}{\out{\hypertarget{method-collections_create}{}}}
\subsection{Method \code{collections_create()}}{
Create a new Collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$collections_create(
  collection,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL,
  replaceFiles = NULL,
  replaceSegments = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{Collection object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}

\item{\code{replaceFiles}}{Add, delete, and replace files and directories with new content
and/or content from other collections. Refer to the
\href{https://doc.arvados.org/api/methods/collections.html#replace_files}{replace_files reference} for details.}

\item{\code{replaceSegments}}{Replace existing block segments in the collection with new segments.
Refer to the \href{https://doc.arvados.org/api/methods/collections.html#replace_segments}{replace_segments reference} for details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Collection object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-collections_update"></a>}}
\if{latex}{\out{\hypertarget{method-collections_update}{}}}
\subsection{Method \code{collections_update()}}{
Update attributes of an existing Collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$collections_update(
  collection,
  uuid,
  select = NULL,
  replaceFiles = NULL,
  replaceSegments = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{Collection object.}

\item{\code{uuid}}{The UUID of the Collection to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{replaceFiles}}{Add, delete, and replace files and directories with new content
and/or content from other collections. Refer to the
\href{https://doc.arvados.org/api/methods/collections.html#replace_files}{replace_files reference} for details.}

\item{\code{replaceSegments}}{Replace existing block segments in the collection with new segments.
Refer to the \href{https://doc.arvados.org/api/methods/collections.html#replace_segments}{replace_segments reference} for details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Collection object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-collections_delete"></a>}}
\if{latex}{\out{\hypertarget{method-collections_delete}{}}}
\subsection{Method \code{collections_delete()}}{
Delete an existing Collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$collections_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Collection to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Collection object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-collections_provenance"></a>}}
\if{latex}{\out{\hypertarget{method-collections_provenance}{}}}
\subsection{Method \code{collections_provenance()}}{
Detail the provenance of a given collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$collections_provenance(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Collection to query.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Collection object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-collections_used_by"></a>}}
\if{latex}{\out{\hypertarget{method-collections_used_by}{}}}
\subsection{Method \code{collections_used_by()}}{
Detail where a given collection has been used.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$collections_used_by(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Collection to query.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Collection object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-collections_trash"></a>}}
\if{latex}{\out{\hypertarget{method-collections_trash}{}}}
\subsection{Method \code{collections_trash()}}{
Trash a collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$collections_trash(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Collection to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Collection object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-collections_untrash"></a>}}
\if{latex}{\out{\hypertarget{method-collections_untrash}{}}}
\subsection{Method \code{collections_untrash()}}{
Untrash a collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$collections_untrash(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Collection to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Collection object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-computed_permissions_list"></a>}}
\if{latex}{\out{\hypertarget{method-computed_permissions_list}{}}}
\subsection{Method \code{computed_permissions_list()}}{
Retrieve a ComputedPermissionList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$computed_permissions_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  count = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ComputedPermissionList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-containers_get"></a>}}
\if{latex}{\out{\hypertarget{method-containers_get}{}}}
\subsection{Method \code{containers_get()}}{
Get a Container record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$containers_get(uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Container to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Container object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-containers_list"></a>}}
\if{latex}{\out{\hypertarget{method-containers_list}{}}}
\subsection{Method \code{containers_list()}}{
Retrieve a ContainerList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$containers_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ContainerList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-containers_create"></a>}}
\if{latex}{\out{\hypertarget{method-containers_create}{}}}
\subsection{Method \code{containers_create()}}{
Create a new Container.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$containers_create(
  container,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{container}}{Container object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Container object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-containers_update"></a>}}
\if{latex}{\out{\hypertarget{method-containers_update}{}}}
\subsection{Method \code{containers_update()}}{
Update attributes of an existing Container.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$containers_update(container, uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{container}}{Container object.}

\item{\code{uuid}}{The UUID of the Container to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Container object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-containers_delete"></a>}}
\if{latex}{\out{\hypertarget{method-containers_delete}{}}}
\subsection{Method \code{containers_delete()}}{
Delete an existing Container.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$containers_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Container to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Container object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-containers_auth"></a>}}
\if{latex}{\out{\hypertarget{method-containers_auth}{}}}
\subsection{Method \code{containers_auth()}}{
Get the API client authorization token associated with this container.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$containers_auth(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Container to query.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Container object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-containers_lock"></a>}}
\if{latex}{\out{\hypertarget{method-containers_lock}{}}}
\subsection{Method \code{containers_lock()}}{
Lock a container (for a dispatcher to begin running it).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$containers_lock(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Container to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Container object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-containers_unlock"></a>}}
\if{latex}{\out{\hypertarget{method-containers_unlock}{}}}
\subsection{Method \code{containers_unlock()}}{
Unlock a container (for a dispatcher to stop running it).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$containers_unlock(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Container to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Container object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-containers_update_priority"></a>}}
\if{latex}{\out{\hypertarget{method-containers_update_priority}{}}}
\subsection{Method \code{containers_update_priority()}}{
Recalculate and return the priority of a given container.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$containers_update_priority(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Container to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Container object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-containers_secret_mounts"></a>}}
\if{latex}{\out{\hypertarget{method-containers_secret_mounts}{}}}
\subsection{Method \code{containers_secret_mounts()}}{
Return secret mount information for the container associated with the API token authorizing this request.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$containers_secret_mounts(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Container to query.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Container object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-containers_current"></a>}}
\if{latex}{\out{\hypertarget{method-containers_current}{}}}
\subsection{Method \code{containers_current()}}{
Return the container record associated with the API token authorizing this request.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$containers_current()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Container object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-container_requests_get"></a>}}
\if{latex}{\out{\hypertarget{method-container_requests_get}{}}}
\subsection{Method \code{container_requests_get()}}{
Get a ContainerRequest record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$container_requests_get(uuid, select = NULL, includeTrash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the ContainerRequest to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{includeTrash}}{Show container request even if its owner project is trashed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ContainerRequest object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-container_requests_list"></a>}}
\if{latex}{\out{\hypertarget{method-container_requests_list}{}}}
\subsection{Method \code{container_requests_list()}}{
Retrieve a ContainerRequestList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$container_requests_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL,
  includeTrash = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}

\item{\code{includeTrash}}{Include container requests whose owner project is trashed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ContainerRequestList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-container_requests_create"></a>}}
\if{latex}{\out{\hypertarget{method-container_requests_create}{}}}
\subsection{Method \code{container_requests_create()}}{
Create a new ContainerRequest.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$container_requests_create(
  containerRequest,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{containerRequest}}{ContainerRequest object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ContainerRequest object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-container_requests_update"></a>}}
\if{latex}{\out{\hypertarget{method-container_requests_update}{}}}
\subsection{Method \code{container_requests_update()}}{
Update attributes of an existing ContainerRequest.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$container_requests_update(containerRequest, uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{containerRequest}}{ContainerRequest object.}

\item{\code{uuid}}{The UUID of the ContainerRequest to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ContainerRequest object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-container_requests_delete"></a>}}
\if{latex}{\out{\hypertarget{method-container_requests_delete}{}}}
\subsection{Method \code{container_requests_delete()}}{
Delete an existing ContainerRequest.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$container_requests_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the ContainerRequest to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ContainerRequest object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-container_requests_container_status"></a>}}
\if{latex}{\out{\hypertarget{method-container_requests_container_status}{}}}
\subsection{Method \code{container_requests_container_status()}}{
Return scheduling details for a container request.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$container_requests_container_status(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the container request to query.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ContainerRequest object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-groups_get"></a>}}
\if{latex}{\out{\hypertarget{method-groups_get}{}}}
\subsection{Method \code{groups_get()}}{
Get a Group record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$groups_get(uuid, select = NULL, includeTrash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Group to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{includeTrash}}{Return group/project even if its \code{is_trashed} attribute is true.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-groups_list"></a>}}
\if{latex}{\out{\hypertarget{method-groups_list}{}}}
\subsection{Method \code{groups_list()}}{
Retrieve a GroupList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$groups_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL,
  includeTrash = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}

\item{\code{includeTrash}}{Include items whose \code{is_trashed} attribute is true.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
GroupList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-groups_create"></a>}}
\if{latex}{\out{\hypertarget{method-groups_create}{}}}
\subsection{Method \code{groups_create()}}{
Create a new Group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$groups_create(
  group,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL,
  async = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{Group object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}

\item{\code{async}}{If true, cluster permission will not be updated immediately, but instead at the next configured update interval.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-groups_update"></a>}}
\if{latex}{\out{\hypertarget{method-groups_update}{}}}
\subsection{Method \code{groups_update()}}{
Update attributes of an existing Group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$groups_update(group, uuid, select = NULL, async = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{Group object.}

\item{\code{uuid}}{The UUID of the Group to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{async}}{If true, cluster permission will not be updated immediately, but instead at the next configured update interval.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-groups_delete"></a>}}
\if{latex}{\out{\hypertarget{method-groups_delete}{}}}
\subsection{Method \code{groups_delete()}}{
Delete an existing Group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$groups_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Group to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-groups_contents"></a>}}
\if{latex}{\out{\hypertarget{method-groups_contents}{}}}
\subsection{Method \code{groups_contents()}}{
List objects that belong to a group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$groups_contents(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL,
  includeTrash = NULL,
  uuid = NULL,
  recursive = NULL,
  include = NULL,
  includeOldVersions = NULL,
  excludeHomeProject = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}

\item{\code{includeTrash}}{Include items whose \code{is_trashed} attribute is true.}

\item{\code{uuid}}{If given, limit the listing to objects owned by the
user or group with this UUID.}

\item{\code{recursive}}{If true, include contents from child groups recursively.}

\item{\code{include}}{An array of referenced objects to include in the \code{included} field of the response. Supported values in the array are:
\itemize{
\item \code{"container_uuid"}
\item \code{"owner_uuid"}
}}

\item{\code{includeOldVersions}}{If true, include past versions of collections in the listing.}

\item{\code{excludeHomeProject}}{If true, exclude contents of the user's home project from the listing.
Calling this method with this flag set is how clients enumerate objects shared
with the current user.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-groups_shared"></a>}}
\if{latex}{\out{\hypertarget{method-groups_shared}{}}}
\subsection{Method \code{groups_shared()}}{
List groups that the current user can access via permission links.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$groups_shared(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL,
  includeTrash = NULL,
  include = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}

\item{\code{includeTrash}}{Include items whose \code{is_trashed} attribute is true.}

\item{\code{include}}{A string naming referenced objects to include in the \code{included} field of the response. Supported values are:
\itemize{
\item \code{"owner_uuid"}
}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-groups_trash"></a>}}
\if{latex}{\out{\hypertarget{method-groups_trash}{}}}
\subsection{Method \code{groups_trash()}}{
Trash a group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$groups_trash(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Group to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-groups_untrash"></a>}}
\if{latex}{\out{\hypertarget{method-groups_untrash}{}}}
\subsection{Method \code{groups_untrash()}}{
Untrash a group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$groups_untrash(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Group to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-keep_services_get"></a>}}
\if{latex}{\out{\hypertarget{method-keep_services_get}{}}}
\subsection{Method \code{keep_services_get()}}{
Get a KeepService record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$keep_services_get(uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the KeepService to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
KeepService object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-keep_services_list"></a>}}
\if{latex}{\out{\hypertarget{method-keep_services_list}{}}}
\subsection{Method \code{keep_services_list()}}{
Retrieve a KeepServiceList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$keep_services_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
KeepServiceList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-keep_services_create"></a>}}
\if{latex}{\out{\hypertarget{method-keep_services_create}{}}}
\subsection{Method \code{keep_services_create()}}{
Create a new KeepService.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$keep_services_create(
  keepService,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keepService}}{KeepService object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
KeepService object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-keep_services_update"></a>}}
\if{latex}{\out{\hypertarget{method-keep_services_update}{}}}
\subsection{Method \code{keep_services_update()}}{
Update attributes of an existing KeepService.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$keep_services_update(keepService, uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keepService}}{KeepService object.}

\item{\code{uuid}}{The UUID of the KeepService to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
KeepService object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-keep_services_delete"></a>}}
\if{latex}{\out{\hypertarget{method-keep_services_delete}{}}}
\subsection{Method \code{keep_services_delete()}}{
Delete an existing KeepService.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$keep_services_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the KeepService to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
KeepService object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-keep_services_accessible"></a>}}
\if{latex}{\out{\hypertarget{method-keep_services_accessible}{}}}
\subsection{Method \code{keep_services_accessible()}}{
List Keep services that the current client can access.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$keep_services_accessible()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
KeepService object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-links_get"></a>}}
\if{latex}{\out{\hypertarget{method-links_get}{}}}
\subsection{Method \code{links_get()}}{
Get a Link record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$links_get(uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Link to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Link object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-links_list"></a>}}
\if{latex}{\out{\hypertarget{method-links_list}{}}}
\subsection{Method \code{links_list()}}{
Retrieve a LinkList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$links_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
LinkList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-links_create"></a>}}
\if{latex}{\out{\hypertarget{method-links_create}{}}}
\subsection{Method \code{links_create()}}{
Create a new Link.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$links_create(
  link,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{link}}{Link object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Link object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-links_update"></a>}}
\if{latex}{\out{\hypertarget{method-links_update}{}}}
\subsection{Method \code{links_update()}}{
Update attributes of an existing Link.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$links_update(link, uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{link}}{Link object.}

\item{\code{uuid}}{The UUID of the Link to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Link object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-links_delete"></a>}}
\if{latex}{\out{\hypertarget{method-links_delete}{}}}
\subsection{Method \code{links_delete()}}{
Delete an existing Link.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$links_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Link to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Link object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-links_get_permissions"></a>}}
\if{latex}{\out{\hypertarget{method-links_get_permissions}{}}}
\subsection{Method \code{links_get_permissions()}}{
List permissions granted on an Arvados object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$links_get_permissions(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Link to query.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Link object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logs_get"></a>}}
\if{latex}{\out{\hypertarget{method-logs_get}{}}}
\subsection{Method \code{logs_get()}}{
Get a Log record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$logs_get(uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Log to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Log object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logs_list"></a>}}
\if{latex}{\out{\hypertarget{method-logs_list}{}}}
\subsection{Method \code{logs_list()}}{
Retrieve a LogList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$logs_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
LogList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logs_create"></a>}}
\if{latex}{\out{\hypertarget{method-logs_create}{}}}
\subsection{Method \code{logs_create()}}{
Create a new Log.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$logs_create(
  log,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{log}}{Log object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Log object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logs_update"></a>}}
\if{latex}{\out{\hypertarget{method-logs_update}{}}}
\subsection{Method \code{logs_update()}}{
Update attributes of an existing Log.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$logs_update(log, uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{log}}{Log object.}

\item{\code{uuid}}{The UUID of the Log to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Log object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logs_delete"></a>}}
\if{latex}{\out{\hypertarget{method-logs_delete}{}}}
\subsection{Method \code{logs_delete()}}{
Delete an existing Log.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$logs_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Log to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Log object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-users_get"></a>}}
\if{latex}{\out{\hypertarget{method-users_get}{}}}
\subsection{Method \code{users_get()}}{
Get a User record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$users_get(uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the User to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
User object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-users_list"></a>}}
\if{latex}{\out{\hypertarget{method-users_list}{}}}
\subsection{Method \code{users_list()}}{
Retrieve a UserList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$users_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
UserList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-users_create"></a>}}
\if{latex}{\out{\hypertarget{method-users_create}{}}}
\subsection{Method \code{users_create()}}{
Create a new User.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$users_create(
  user,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{User object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
User object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-users_update"></a>}}
\if{latex}{\out{\hypertarget{method-users_update}{}}}
\subsection{Method \code{users_update()}}{
Update attributes of an existing User.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$users_update(user, uuid, select = NULL, bypassFederation = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{User object.}

\item{\code{uuid}}{The UUID of the User to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{bypassFederation}}{If true, do not try to update the user on any other clusters in the federation,
only the cluster that received the request.
You must be an administrator to use this flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
User object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-users_delete"></a>}}
\if{latex}{\out{\hypertarget{method-users_delete}{}}}
\subsection{Method \code{users_delete()}}{
Delete an existing User.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$users_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the User to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
User object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-users_current"></a>}}
\if{latex}{\out{\hypertarget{method-users_current}{}}}
\subsection{Method \code{users_current()}}{
Return the user record associated with the API token authorizing this request.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$users_current()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
User object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-users_system"></a>}}
\if{latex}{\out{\hypertarget{method-users_system}{}}}
\subsection{Method \code{users_system()}}{
Return this cluster's system ("root") user record.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$users_system()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
User object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-users_activate"></a>}}
\if{latex}{\out{\hypertarget{method-users_activate}{}}}
\subsection{Method \code{users_activate()}}{
Set the \code{is_active} flag on a user record.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$users_activate(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the User to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
User object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-users_setup"></a>}}
\if{latex}{\out{\hypertarget{method-users_setup}{}}}
\subsection{Method \code{users_setup()}}{
Convenience method to "fully" set up a user record with a virtual machine login and notification email.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$users_setup(
  uuid = NULL,
  user = NULL,
  repoName = NULL,
  vmUUID = NULL,
  sendNotificationEmail = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{UUID of an existing user record to set up.}

\item{\code{user}}{Attributes of a new user record to set up.}

\item{\code{repoName}}{This parameter is obsolete and ignored.}

\item{\code{vmUUID}}{If given, setup creates a login link to allow this user to access the Arvados virtual machine with this UUID.}

\item{\code{sendNotificationEmail}}{If true, send an email to the user notifying them they can now access this Arvados cluster.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
User object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-users_unsetup"></a>}}
\if{latex}{\out{\hypertarget{method-users_unsetup}{}}}
\subsection{Method \code{users_unsetup()}}{
Unset a user's active flag and delete associated records.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$users_unsetup(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the User to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
User object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-users_merge"></a>}}
\if{latex}{\out{\hypertarget{method-users_merge}{}}}
\subsection{Method \code{users_merge()}}{
Transfer ownership of one user's data to another.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$users_merge(
  newOwnerUUID,
  newUserToken = NULL,
  redirectToNewUser = NULL,
  oldUserUUID = NULL,
  newUserUUID = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newOwnerUUID}}{UUID of the user or group that will take ownership of data owned by the old user.}

\item{\code{newUserToken}}{Valid API token for the user receiving ownership. If you use this option, it takes ownership of data owned by the user making the request.}

\item{\code{redirectToNewUser}}{If true, authorization attempts for the old user will be redirected to the new user.}

\item{\code{oldUserUUID}}{UUID of the user whose ownership is being transferred to \code{new_owner_uuid}. You must be an admin to use this option.}

\item{\code{newUserUUID}}{UUID of the user receiving ownership. You must be an admin to use this option.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
User object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-user_agreements_get"></a>}}
\if{latex}{\out{\hypertarget{method-user_agreements_get}{}}}
\subsection{Method \code{user_agreements_get()}}{
Get a UserAgreement record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$user_agreements_get(uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the UserAgreement to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
UserAgreement object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-user_agreements_list"></a>}}
\if{latex}{\out{\hypertarget{method-user_agreements_list}{}}}
\subsection{Method \code{user_agreements_list()}}{
Retrieve a UserAgreementList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$user_agreements_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
UserAgreementList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-user_agreements_create"></a>}}
\if{latex}{\out{\hypertarget{method-user_agreements_create}{}}}
\subsection{Method \code{user_agreements_create()}}{
Create a new UserAgreement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$user_agreements_create(
  userAgreement,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{userAgreement}}{UserAgreement object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
UserAgreement object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-user_agreements_update"></a>}}
\if{latex}{\out{\hypertarget{method-user_agreements_update}{}}}
\subsection{Method \code{user_agreements_update()}}{
Update attributes of an existing UserAgreement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$user_agreements_update(userAgreement, uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{userAgreement}}{UserAgreement object.}

\item{\code{uuid}}{The UUID of the UserAgreement to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
UserAgreement object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-user_agreements_delete"></a>}}
\if{latex}{\out{\hypertarget{method-user_agreements_delete}{}}}
\subsection{Method \code{user_agreements_delete()}}{
Delete an existing UserAgreement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$user_agreements_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the UserAgreement to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
UserAgreement object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-user_agreements_signatures"></a>}}
\if{latex}{\out{\hypertarget{method-user_agreements_signatures}{}}}
\subsection{Method \code{user_agreements_signatures()}}{
List all user agreement signature links from a user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$user_agreements_signatures()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
UserAgreement object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-user_agreements_sign"></a>}}
\if{latex}{\out{\hypertarget{method-user_agreements_sign}{}}}
\subsection{Method \code{user_agreements_sign()}}{
Create a signature link from the current user for a given user agreement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$user_agreements_sign()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
UserAgreement object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-virtual_machines_get"></a>}}
\if{latex}{\out{\hypertarget{method-virtual_machines_get}{}}}
\subsection{Method \code{virtual_machines_get()}}{
Get a VirtualMachine record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$virtual_machines_get(uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the VirtualMachine to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
VirtualMachine object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-virtual_machines_list"></a>}}
\if{latex}{\out{\hypertarget{method-virtual_machines_list}{}}}
\subsection{Method \code{virtual_machines_list()}}{
Retrieve a VirtualMachineList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$virtual_machines_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
VirtualMachineList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-virtual_machines_create"></a>}}
\if{latex}{\out{\hypertarget{method-virtual_machines_create}{}}}
\subsection{Method \code{virtual_machines_create()}}{
Create a new VirtualMachine.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$virtual_machines_create(
  virtualMachine,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{virtualMachine}}{VirtualMachine object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
VirtualMachine object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-virtual_machines_update"></a>}}
\if{latex}{\out{\hypertarget{method-virtual_machines_update}{}}}
\subsection{Method \code{virtual_machines_update()}}{
Update attributes of an existing VirtualMachine.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$virtual_machines_update(virtualMachine, uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{virtualMachine}}{VirtualMachine object.}

\item{\code{uuid}}{The UUID of the VirtualMachine to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
VirtualMachine object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-virtual_machines_delete"></a>}}
\if{latex}{\out{\hypertarget{method-virtual_machines_delete}{}}}
\subsection{Method \code{virtual_machines_delete()}}{
Delete an existing VirtualMachine.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$virtual_machines_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the VirtualMachine to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
VirtualMachine object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-virtual_machines_logins"></a>}}
\if{latex}{\out{\hypertarget{method-virtual_machines_logins}{}}}
\subsection{Method \code{virtual_machines_logins()}}{
List login permission links for a given virtual machine.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$virtual_machines_logins(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the VirtualMachine to query.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
VirtualMachine object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-virtual_machines_get_all_logins"></a>}}
\if{latex}{\out{\hypertarget{method-virtual_machines_get_all_logins}{}}}
\subsection{Method \code{virtual_machines_get_all_logins()}}{
List login permission links for all virtual machines.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$virtual_machines_get_all_logins()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
VirtualMachine object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-workflows_get"></a>}}
\if{latex}{\out{\hypertarget{method-workflows_get}{}}}
\subsection{Method \code{workflows_get()}}{
Get a Workflow record by UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$workflows_get(uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Workflow to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Workflow object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-workflows_list"></a>}}
\if{latex}{\out{\hypertarget{method-workflows_list}{}}}
\subsection{Method \code{workflows_list()}}{
Retrieve a WorkflowList.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$workflows_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
WorkflowList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-workflows_create"></a>}}
\if{latex}{\out{\hypertarget{method-workflows_create}{}}}
\subsection{Method \code{workflows_create()}}{
Create a new Workflow.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$workflows_create(
  workflow,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{workflow}}{Workflow object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Workflow object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-workflows_update"></a>}}
\if{latex}{\out{\hypertarget{method-workflows_update}{}}}
\subsection{Method \code{workflows_update()}}{
Update attributes of an existing Workflow.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$workflows_update(workflow, uuid, select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{workflow}}{Workflow object.}

\item{\code{uuid}}{The UUID of the Workflow to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Workflow object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-workflows_delete"></a>}}
\if{latex}{\out{\hypertarget{method-workflows_delete}{}}}
\subsection{Method \code{workflows_delete()}}{
Delete an existing Workflow.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$workflows_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Workflow to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Workflow object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-configs_get"></a>}}
\if{latex}{\out{\hypertarget{method-configs_get}{}}}
\subsection{Method \code{configs_get()}}{
Get this cluster's public configuration settings.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$configs_get()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vocabularies_get"></a>}}
\if{latex}{\out{\hypertarget{method-vocabularies_get}{}}}
\subsection{Method \code{vocabularies_get()}}{
Get this cluster's configured vocabulary definition.

Refer to \href{https://doc.aravdos.org/admin/metadata-vocabulary.html}{metadata vocabulary documentation} for details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$vocabularies_get()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sys_get"></a>}}
\if{latex}{\out{\hypertarget{method-sys_get}{}}}
\subsection{Method \code{sys_get()}}{
Run scheduled data trash and sweep operations across this cluster's Keep services.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$sys_get()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_get"></a>}}
\if{latex}{\out{\hypertarget{method-project_get}{}}}
\subsection{Method \code{project_get()}}{
An alias for \code{groups_get}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_get(uuid, select = NULL, includeTrash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Group to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{includeTrash}}{Return group/project even if its \code{is_trashed} attribute is true.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_create"></a>}}
\if{latex}{\out{\hypertarget{method-project_create}{}}}
\subsection{Method \code{project_create()}}{
A wrapper for \code{groups_create} that sets \code{group_class="project"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_create(
  group,
  select = NULL,
  ensureUniqueName = NULL,
  clusterID = NULL,
  async = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{Group object.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{ensureUniqueName}}{If the given name is already used by this owner, adjust the name to ensure uniqueness instead of returning an error.}

\item{\code{clusterID}}{Cluster ID of a federated cluster where this object should be created.}

\item{\code{async}}{If true, cluster permission will not be updated immediately, but instead at the next configured update interval.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_update"></a>}}
\if{latex}{\out{\hypertarget{method-project_update}{}}}
\subsection{Method \code{project_update()}}{
A wrapper for \code{groups_update} that sets \code{group_class="project"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_update(group, uuid, select = NULL, async = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{Group object.}

\item{\code{uuid}}{The UUID of the Group to update.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{async}}{If true, cluster permission will not be updated immediately, but instead at the next configured update interval.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_list"></a>}}
\if{latex}{\out{\hypertarget{method-project_list}{}}}
\subsection{Method \code{project_list()}}{
A wrapper for \code{groups_list} that adds a filter for \code{group_class="project"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_list(
  filters = NULL,
  where = NULL,
  order = NULL,
  select = NULL,
  distinct = NULL,
  limit = NULL,
  offset = NULL,
  count = NULL,
  clusterID = NULL,
  bypassFederation = NULL,
  includeTrash = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filters}}{Filters to limit which objects are returned by their attributes.
Refer to the \href{https://doc.arvados.org/api/methods.html#filters}{filters reference} for more information about how to write filters.}

\item{\code{where}}{An object to limit which objects are returned by their attributes.
The keys of this object are attribute names.
Each value is either a single matching value or an array of matching values for that attribute.
The \code{filters} parameter is more flexible and preferred.}

\item{\code{order}}{An array of strings to set the order in which matching objects are returned.
Each string has the format \verb{<ATTRIBUTE> <DIRECTION>}.
\code{DIRECTION} can be \code{asc} or omitted for ascending, or \code{desc} for descending.}

\item{\code{select}}{An array of names of attributes to return from each matching object.}

\item{\code{distinct}}{If this is true, and multiple objects have the same values
for the attributes that you specify in the \code{select} parameter, then each unique
set of values will only be returned once in the result set.}

\item{\code{limit}}{The maximum number of objects to return in the result.
Note that the API may return fewer results than this if your request hits other
limits set by the administrator.}

\item{\code{offset}}{Return matching objects starting from this index.
Note that result indexes may change if objects are modified in between a series
of list calls.}

\item{\code{count}}{A string to determine result counting behavior. Supported values are:
\itemize{
\item \code{"exact"}: The response will include an \code{items_available} field that
counts the number of objects that matched this search criteria,
including ones not included in \code{items}.
\item \code{"none"}: The response will not include an \code{items_avaliable}
field. This improves performance by returning a result as soon as enough
\code{items} have been loaded for this result.
}}

\item{\code{clusterID}}{Cluster ID of a federated cluster to return objects from}

\item{\code{bypassFederation}}{If true, do not return results from other clusters in the
federation, only the cluster that received the request.
You must be an administrator to use this flag.}

\item{\code{includeTrash}}{Include items whose \code{is_trashed} attribute is true.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A GroupList object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_delete"></a>}}
\if{latex}{\out{\hypertarget{method-project_delete}{}}}
\subsection{Method \code{project_delete()}}{
An alias for \code{groups_delete}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_delete(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Group to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_exist"></a>}}
\if{latex}{\out{\hypertarget{method-project_exist}{}}}
\subsection{Method \code{project_exist()}}{
Test whether or not a project exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_exist(uuid, select = NULL, includeTrash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the Group to return.}

\item{\code{select}}{An array of names of attributes to return in the response.}

\item{\code{includeTrash}}{Return group/project even if its \code{is_trashed} attribute is true.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_properties_set"></a>}}
\if{latex}{\out{\hypertarget{method-project_properties_set}{}}}
\subsection{Method \code{project_properties_set()}}{
A convenience wrapper for \code{project_update} to set project metadata properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_properties_set(listProperties, uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{listProperties}}{List of new properties.}

\item{\code{uuid}}{UUID of the project to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_properties_append"></a>}}
\if{latex}{\out{\hypertarget{method-project_properties_append}{}}}
\subsection{Method \code{project_properties_append()}}{
Get a project and update it with additional properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_properties_append(properties, uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{properties}}{List of new properties.}

\item{\code{uuid}}{UUID of the project to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_properties_get"></a>}}
\if{latex}{\out{\hypertarget{method-project_properties_get}{}}}
\subsection{Method \code{project_properties_get()}}{
Get properties of a project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_properties_get(uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the project to query.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_properties_delete"></a>}}
\if{latex}{\out{\hypertarget{method-project_properties_delete}{}}}
\subsection{Method \code{project_properties_delete()}}{
Delete one property from a project by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_properties_delete(oneProp, uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{oneProp}}{Name of the property to delete.}

\item{\code{uuid}}{The UUID of the project to update.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Group object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_permission_give"></a>}}
\if{latex}{\out{\hypertarget{method-project_permission_give}{}}}
\subsection{Method \code{project_permission_give()}}{
Convenience wrapper of \code{links_list} to create a permission link.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_permission_give(type, uuid, user)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{The type of permission: one of \code{'can_read'}, \code{'can_write'}, or \code{'can_manage'}.}

\item{\code{uuid}}{The UUID of the object to grant permission to.}

\item{\code{user}}{The UUID of the user or group who receives this permission.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Link object if one was updated, else NULL.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_permission_update"></a>}}
\if{latex}{\out{\hypertarget{method-project_permission_update}{}}}
\subsection{Method \code{project_permission_update()}}{
Find an existing permission link and update its level.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_permission_update(typeOld, typeNew, uuid, user)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{typeOld}}{The type of permission to find: one of \code{'can_read'}, \code{'can_write'}, or \code{'can_manage'}.}

\item{\code{typeNew}}{The type of permission to set: one of \code{'can_read'}, \code{'can_write'}, or \code{'can_manage'}.}

\item{\code{uuid}}{The UUID of the object to grant permission to.}

\item{\code{user}}{The UUID of the user or group who receives this permission.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Link object if one was updated, else NULL.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_permission_delete"></a>}}
\if{latex}{\out{\hypertarget{method-project_permission_delete}{}}}
\subsection{Method \code{project_permission_delete()}}{
Delete an existing permission link.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_permission_delete(type, uuid, user)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{The type of permission to delete: one of \code{'can_read'}, \code{'can_write'}, or \code{'can_manage'}.}

\item{\code{uuid}}{The UUID of the object to grant permission to.}

\item{\code{user}}{The UUID of the user or group who receives this permission.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Link object if one was deleted, else NULL.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project_permission_check"></a>}}
\if{latex}{\out{\hypertarget{method-project_permission_check}{}}}
\subsection{Method \code{project_permission_check()}}{
Check for an existing permission link.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$project_permission_check(uuid, user, type = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uuid}}{The UUID of the object to check permission on.}

\item{\code{user}}{The UUID of the user or group to check permission for.}

\item{\code{type}}{The type of permission to check: one of \code{'can_read'}, \code{'can_write'}, \code{'can_manage'}, or \code{NULL} (the default).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{type} is \code{NULL}, the list of matching permission links.
Otherwise, prints and invisibly returns the level of the found permission link.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getHostName"></a>}}
\if{latex}{\out{\hypertarget{method-getHostName}{}}}
\subsection{Method \code{getHostName()}}{
Return the host name of this client's Arvados API server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$getHostName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Hostname string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getToken"></a>}}
\if{latex}{\out{\hypertarget{method-getToken}{}}}
\subsection{Method \code{getToken()}}{
Return the Arvados API token used by this client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$getToken()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
API token string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setRESTService"></a>}}
\if{latex}{\out{\hypertarget{method-setRESTService}{}}}
\subsection{Method \code{setRESTService()}}{
Set the RESTService object used by this client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$setRESTService(newREST)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getRESTService"></a>}}
\if{latex}{\out{\hypertarget{method-getRESTService}{}}}
\subsection{Method \code{getRESTService()}}{
Return the RESTService object used by this client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arvados$getRESTService()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
RESTService object.
}
}
}
