% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collection.R
\name{Collection}
\alias{Collection}
\title{R6 Class Representing Arvados Collection}
\description{
Collection class provides interface for working with Arvados collections,
for exaplme actions like creating, updating, moving or removing are possible.
}
\examples{

## ------------------------------------------------
## Method `Collection$new`
## ------------------------------------------------

\dontrun{
collection <- Collection$new(arv, CollectionUUID)
}

## ------------------------------------------------
## Method `Collection$readArvFile`
## ------------------------------------------------

\dontrun{
collection <- Collection$new(arv, collectionUUID)
readFile <- collection$readArvFile(arvadosFile, istable = 'yes')                    # table
readFile <- collection$readArvFile(arvadosFile, istable = 'no')                     # text
readFile <- collection$readArvFile(arvadosFile)                                     # xlsx, csv, tsv, rds, rdata
readFile <- collection$readArvFile(arvadosFile, fileclass = 'fasta')                # fasta
readFile <- collection$readArvFile(arvadosFile, Ncol= 4, Nrow = 32)                 # binary, only numbers
readFile <- collection$readArvFile(arvadosFile, Ncol = 5, Nrow = 150, istable = "factor") # binary with factor or text
}

## ------------------------------------------------
## Method `Collection$writeFile`
## ------------------------------------------------

\dontrun{
collection <- Collection$new(arv, collectionUUID)
writeFile <- collection$writeFile(name = "myoutput.csv", file = file, fileFormat = "csv", istable = NULL, collectionUUID = collectionUUID)             # csv
writeFile <- collection$writeFile(name = "myoutput.tsv", file = file, fileFormat = "tsv", istable = NULL, collectionUUID = collectionUUID)             # tsv
writeFile <- collection$writeFile(name = "myoutput.fasta", file = file, fileFormat = "fasta", istable = NULL, collectionUUID = collectionUUID)         # fasta
writeFile <- collection$writeFile(name = "myoutputtable.txt", file = file, fileFormat = "txt", istable = "yes", collectionUUID = collectionUUID)       # txt table
writeFile <- collection$writeFile(name = "myoutputtext.txt", file = file, fileFormat = "txt", istable = "no", collectionUUID = collectionUUID)         # txt text
writeFile <- collection$writeFile(name = "myoutputbinary.dat", file = file, fileFormat = "dat", collectionUUID = collectionUUID)                       # binary
writeFile <- collection$writeFile(name = "myoutputxlsx.xlsx", file = file, fileFormat = "xlsx", collectionUUID = collectionUUID)                       # xlsx
}

## ------------------------------------------------
## Method `Collection$create`
## ------------------------------------------------

\dontrun{
collection <- arv$collections_create(name = collectionTitle, description = collectionDescription, owner_uuid = collectionOwner, properties = list("ROX37196928443768648" = "ROX37742976443830153"))
}

## ------------------------------------------------
## Method `Collection$remove`
## ------------------------------------------------

\dontrun{
collection$remove(fileName.format)
}

## ------------------------------------------------
## Method `Collection$move`
## ------------------------------------------------

\dontrun{
collection$move("fileName.format", path)
}

## ------------------------------------------------
## Method `Collection$copy`
## ------------------------------------------------

\dontrun{
copied <- collection$copy("oldName.format", "newName.format")
}

## ------------------------------------------------
## Method `Collection$refresh`
## ------------------------------------------------

\dontrun{
collection$refresh()
}

## ------------------------------------------------
## Method `Collection$getFileListing`
## ------------------------------------------------

\dontrun{
list <- collection$getFileListing()
}

## ------------------------------------------------
## Method `Collection$get`
## ------------------------------------------------

\dontrun{
arvadosFile <- collection$get(fileName)
}
}
\seealso{
https://git.arvados.org/arvados.git/tree/HEAD:/sdk/R
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{uuid}}{Autentic for Collection UUID.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Collection-new}{\code{Collection$new()}}
\item \href{#method-Collection-add}{\code{Collection$add()}}
\item \href{#method-Collection-readArvFile}{\code{Collection$readArvFile()}}
\item \href{#method-Collection-writeFile}{\code{Collection$writeFile()}}
\item \href{#method-Collection-create}{\code{Collection$create()}}
\item \href{#method-Collection-remove}{\code{Collection$remove()}}
\item \href{#method-Collection-move}{\code{Collection$move()}}
\item \href{#method-Collection-copy}{\code{Collection$copy()}}
\item \href{#method-Collection-refresh}{\code{Collection$refresh()}}
\item \href{#method-Collection-getFileListing}{\code{Collection$getFileListing()}}
\item \href{#method-Collection-get}{\code{Collection$get()}}
\item \href{#method-Collection-getRESTService}{\code{Collection$getRESTService()}}
\item \href{#method-Collection-setRESTService}{\code{Collection$setRESTService()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-new"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-new}{}}}
\subsection{Method \code{new()}}{
Initialize new enviroment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$new(api, uuid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api}}{Arvados enviroment.}

\item{\code{uuid}}{The UUID Autentic for Collection UUID.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Collection} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
collection <- Collection$new(arv, CollectionUUID)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-add"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-add}{}}}
\subsection{Method \code{add()}}{
Adds ArvadosFile or Subcollection specified by content to the collection. Used only with ArvadosFile or Subcollection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$add(content, relativePath = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{Content to be added.}

\item{\code{relativePath}}{Path to add content.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-readArvFile"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-readArvFile}{}}}
\subsection{Method \code{readArvFile()}}{
Read file content.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$readArvFile(
  file,
  con,
  sep = ",",
  istable = NULL,
  fileclass = "SeqFastadna",
  Ncol = NULL,
  Nrow = NULL,
  wantedFunction = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{Name of the file.}

\item{\code{sep}}{Separator used in reading tsv, csv file format.}

\item{\code{istable}}{Used in reading txt file to check if the file is table or not.}

\item{\code{fileclass}}{Used in reading fasta file to set file class.}

\item{\code{Ncol}}{Used in reading binary file to set numbers of columns in data.frame.}

\item{\code{Nrow}}{Used in reading binary file to set numbers of rows in data.frame size.}

\item{\code{col}}{Collection from which the file is read.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
collection <- Collection$new(arv, collectionUUID)
readFile <- collection$readArvFile(arvadosFile, istable = 'yes')                    # table
readFile <- collection$readArvFile(arvadosFile, istable = 'no')                     # text
readFile <- collection$readArvFile(arvadosFile)                                     # xlsx, csv, tsv, rds, rdata
readFile <- collection$readArvFile(arvadosFile, fileclass = 'fasta')                # fasta
readFile <- collection$readArvFile(arvadosFile, Ncol= 4, Nrow = 32)                 # binary, only numbers
readFile <- collection$readArvFile(arvadosFile, Ncol = 5, Nrow = 150, istable = "factor") # binary with factor or text
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-writeFile"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-writeFile}{}}}
\subsection{Method \code{writeFile()}}{
Write file content
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$writeFile(
  name,
  file,
  collectionUUID,
  fileFormat,
  istable = NULL,
  seqName = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the file.}

\item{\code{file}}{File to be saved.}

\item{\code{istable}}{Used in writing txt file to check if the file is table or not.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
collection <- Collection$new(arv, collectionUUID)
writeFile <- collection$writeFile(name = "myoutput.csv", file = file, fileFormat = "csv", istable = NULL, collectionUUID = collectionUUID)             # csv
writeFile <- collection$writeFile(name = "myoutput.tsv", file = file, fileFormat = "tsv", istable = NULL, collectionUUID = collectionUUID)             # tsv
writeFile <- collection$writeFile(name = "myoutput.fasta", file = file, fileFormat = "fasta", istable = NULL, collectionUUID = collectionUUID)         # fasta
writeFile <- collection$writeFile(name = "myoutputtable.txt", file = file, fileFormat = "txt", istable = "yes", collectionUUID = collectionUUID)       # txt table
writeFile <- collection$writeFile(name = "myoutputtext.txt", file = file, fileFormat = "txt", istable = "no", collectionUUID = collectionUUID)         # txt text
writeFile <- collection$writeFile(name = "myoutputbinary.dat", file = file, fileFormat = "dat", collectionUUID = collectionUUID)                       # binary
writeFile <- collection$writeFile(name = "myoutputxlsx.xlsx", file = file, fileFormat = "xlsx", collectionUUID = collectionUUID)                       # xlsx
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-create"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-create}{}}}
\subsection{Method \code{create()}}{
Creates one or more ArvadosFiles and adds them to the collection at specified path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$create(files)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{files}}{Content to be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
collection <- arv$collections_create(name = collectionTitle, description = collectionDescription, owner_uuid = collectionOwner, properties = list("ROX37196928443768648" = "ROX37742976443830153"))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-remove"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-remove}{}}}
\subsection{Method \code{remove()}}{
Remove one or more files from the collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$remove(paths)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{paths}}{Content to be removed.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
collection$remove(fileName.format)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-move"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-move}{}}}
\subsection{Method \code{move()}}{
Moves ArvadosFile or Subcollection to another location in the collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$move(content, destination)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{Content to be moved.}

\item{\code{destination}}{Path to move content.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
collection$move("fileName.format", path)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-copy"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-copy}{}}}
\subsection{Method \code{copy()}}{
Copies ArvadosFile or Subcollection to another location in the collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$copy(content, destination)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{Content to be moved.}

\item{\code{destination}}{Path to move content.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
copied <- collection$copy("oldName.format", "newName.format")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-refresh"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-refresh}{}}}
\subsection{Method \code{refresh()}}{
Refreshes the environment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$refresh()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
collection$refresh()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-getFileListing"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-getFileListing}{}}}
\subsection{Method \code{getFileListing()}}{
Returns collections file content as character vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$getFileListing()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
list <- collection$getFileListing()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-get"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-get}{}}}
\subsection{Method \code{get()}}{
If relativePath is valid, returns ArvadosFile or Subcollection specified by relativePath, else returns NULL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$get(relativePath)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{relativePath}}{Path from content is taken.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
arvadosFile <- collection$get(fileName)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-getRESTService"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-getRESTService}{}}}
\subsection{Method \code{getRESTService()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$getRESTService()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-setRESTService"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-setRESTService}{}}}
\subsection{Method \code{setRESTService()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$setRESTService(newRESTService)}\if{html}{\out{</div>}}
}

}
}
