% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Subcollection.R
\name{Subcollection}
\alias{Subcollection}
\title{R6 Class Representing a Subcollection}
\description{
Subcollection class represents a folder inside Arvados collection.
It is essentially a composite of arvadosFiles and other subcollections.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Subcollection-new}{\code{Subcollection$new()}}
\item \href{#method-Subcollection-getName}{\code{Subcollection$getName()}}
\item \href{#method-Subcollection-getRelativePath}{\code{Subcollection$getRelativePath()}}
\item \href{#method-Subcollection-add}{\code{Subcollection$add()}}
\item \href{#method-Subcollection-remove}{\code{Subcollection$remove()}}
\item \href{#method-Subcollection-getFileListing}{\code{Subcollection$getFileListing()}}
\item \href{#method-Subcollection-getSizeInBytes}{\code{Subcollection$getSizeInBytes()}}
\item \href{#method-Subcollection-move}{\code{Subcollection$move()}}
\item \href{#method-Subcollection-copy}{\code{Subcollection$copy()}}
\item \href{#method-Subcollection-duplicate}{\code{Subcollection$duplicate()}}
\item \href{#method-Subcollection-get}{\code{Subcollection$get()}}
\item \href{#method-Subcollection-getFirst}{\code{Subcollection$getFirst()}}
\item \href{#method-Subcollection-setCollection}{\code{Subcollection$setCollection()}}
\item \href{#method-Subcollection-getCollection}{\code{Subcollection$getCollection()}}
\item \href{#method-Subcollection-getParent}{\code{Subcollection$getParent()}}
\item \href{#method-Subcollection-setParent}{\code{Subcollection$setParent()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-new"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-new}{}}}
\subsection{Method \code{new()}}{
Initialize new enviroment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$new(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the new enviroment.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Subcollection} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-getName"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-getName}{}}}
\subsection{Method \code{getName()}}{
Returns name of the file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$getName()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-getRelativePath"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-getRelativePath}{}}}
\subsection{Method \code{getRelativePath()}}{
Returns Subcollection's path relative to the root.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$getRelativePath()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-add"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-add}{}}}
\subsection{Method \code{add()}}{
Adds ArvadosFile or Subcollection specified by content to the Subcollection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$add(content)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{Content to be added.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-remove"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-remove}{}}}
\subsection{Method \code{remove()}}{
Removes ArvadosFile or Subcollection specified by name from the Subcollection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$remove(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the file to be removed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-getFileListing"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-getFileListing}{}}}
\subsection{Method \code{getFileListing()}}{
Returns Subcollections file content as character vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$getFileListing(fullPath = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fullPath}}{Checking if the path to file exists.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-getSizeInBytes"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-getSizeInBytes}{}}}
\subsection{Method \code{getSizeInBytes()}}{
Returns subcollections content size in bytes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$getSizeInBytes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-move"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-move}{}}}
\subsection{Method \code{move()}}{
Moves Subcollection to a new location inside collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$move(destination)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{destination}}{Path to move the file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-copy"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-copy}{}}}
\subsection{Method \code{copy()}}{
Copies Subcollection to a new location inside collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$copy(destination)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{destination}}{Path to copy the file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-duplicate"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-duplicate}{}}}
\subsection{Method \code{duplicate()}}{
Duplicate Subcollection and gives it a new name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$duplicate(newName = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newName}}{New name for duplicated file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-get"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-get}{}}}
\subsection{Method \code{get()}}{
If name is valid, returns ArvadosFile or Subcollection specified by relativePath, else returns NULL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$get(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-getFirst"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-getFirst}{}}}
\subsection{Method \code{getFirst()}}{
Returns files in Subcollection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$getFirst()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-setCollection"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-setCollection}{}}}
\subsection{Method \code{setCollection()}}{
Sets Collection by its UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$setCollection(collection, setRecursively = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-getCollection"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-getCollection}{}}}
\subsection{Method \code{getCollection()}}{
Returns Collection of Subcollection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$getCollection()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-getParent"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-getParent}{}}}
\subsection{Method \code{getParent()}}{
Returns Collection UUID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$getParent()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Subcollection-setParent"></a>}}
\if{latex}{\out{\hypertarget{method-Subcollection-setParent}{}}}
\subsection{Method \code{setParent()}}{
Sets new Collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Subcollection$setParent(newParent)}\if{html}{\out{</div>}}
}

}
}
